/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.colony.jobs.JobCookAssistant;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingCook
extends AbstractBuildingFurnaceUser
implements IBuildingPublicCrafter {
    private static final String COOK_DESC = "cook";
    public static final String FOOD_EXCLUSION_LIST = "food";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean isCooking = false;
    private ICitizenData assistant = null;
    private int isCookingTimeout = 0;
    private boolean initTags = false;
    private List<BlockPos> sitPositions;
    private int lastSitting = 0;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> this.isAllowedFood((ItemStack)stack), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack.getContainerItem()) == false && !stack.getContainerItem().func_77973_b().equals(Items.field_151133_ar), new Tuple((Object)64, (Object)false));
    }

    public boolean isAllowedFood(ItemStack stack) {
        ItemListModule listModule = this.getModuleMatching(ItemListModule.class, m -> m.getId().equals(FOOD_EXCLUSION_LIST));
        return ItemStackUtils.ISFOOD.test(stack) && !listModule.isItemInList(new ItemStorage(stack)) && !listModule.isItemInList(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack)));
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        AbstractTileEntityColonyBuilding te = this.getTileEntity();
        if (te != null) {
            this.initTags = true;
            this.sitPositions = new ArrayList<BlockPos>();
            for (Map.Entry entry : te.getWorldTagPosMap().entrySet()) {
                if (!((List)entry.getValue()).contains("sit")) continue;
                this.sitPositions.add((BlockPos)entry.getKey());
            }
        }
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.initTags = false;
    }

    public BlockPos getNextSittingPosition() {
        this.initTagPositions();
        if (this.sitPositions.isEmpty()) {
            return null;
        }
        ++this.lastSitting;
        if (this.lastSitting >= this.sitPositions.size()) {
            this.lastSitting = 0;
        }
        return this.sitPositions.get(this.lastSitting);
    }

    public boolean getIsCooking() {
        ICitizenData citizen = this.getAssistant();
        return citizen != null && this.isCooking && this.isCookingTimeout > 0;
    }

    public void setIsCooking(boolean cookingState) {
        this.isCooking = cookingState;
        if (cookingState) {
            this.isCookingTimeout = 75;
        }
    }

    public ICitizenData getAssistant() {
        if (this.getBuildingLevel() < 3) {
            return null;
        }
        if (this.assistant == null) {
            for (ICitizenData citizen : this.getAssignedCitizen()) {
                if (!(citizen.getJob() instanceof JobCookAssistant)) continue;
                this.assistant = citizen;
            }
        }
        return this.assistant;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        if (citizen != null) {
            for (ICitizenData leadCitizen : this.getAssignedCitizen()) {
                if (!(leadCitizen.getJob() instanceof JobCook)) continue;
                this.assistant = citizen;
                return new JobCookAssistant(citizen);
            }
        }
        return new JobCook(citizen);
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen.getJob() instanceof JobCookAssistant) {
            this.assistant = null;
        }
        super.removeCitizen(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxInhabitants() {
        if (this.getBuildingLevel() < 3) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean canBeGathered() {
        return super.canBeGathered() && this.getAssignedCitizen().stream().map(c -> c.getJob(AbstractJobCrafter.class)).filter(Objects::nonNull).allMatch(AbstractJobCrafter::hasTask);
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Adaptability;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Knowledge;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (inventory && this.getFirstModuleOccurance(MinimumStockModule.class).isStocked(stack)) {
            return stack.func_190916_E();
        }
        ItemListModule listModule = this.getModuleMatching(ItemListModule.class, m -> m.getId().equals(FOOD_EXCLUSION_LIST));
        if (this.isAllowedFood(stack) && (localAlreadyKept.stream().filter(storage -> ItemStackUtils.ISFOOD.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        Predicate<ItemStack> allowedFuel = theStack -> this.getAllowedFuel().stream().anyMatch(fuelStack -> fuelStack.func_77969_a(theStack));
        if (allowedFuel.test(stack) && (localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.cook;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (this.isCookingTimeout > 0) {
            --this.isCookingTimeout;
        }
    }

    @Override
    public Skill getCraftSpeedSkill() {
        return this.getSecondarySkill();
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobCook(null));
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return ItemStackUtils.CAN_EAT.test(recipe.getPrimaryOutput());
        }

        @Override
        @Nullable
        public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
            if (this.building.getBuildingLevel() < 3 || ((BuildingCook)this.building).getAssistant() == null) {
                return null;
            }
            IRecipeStorage storage = super.getFirstRecipe(stackPredicate);
            if (storage != null) {
                return storage;
            }
            storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate);
            if (storage != null && storage.getRecipeSource() != null && ItemStackUtils.ISFOOD.test(storage.getPrimaryOutput().getStack()) && this.isRecipeCompatible(GenericRecipe.of(storage))) {
                return storage;
            }
            return null;
        }

        @Override
        public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
            IRecipeStorage storage = super.getFirstFulfillableRecipe(stackPredicate, count, considerReservation);
            if (storage == null && (storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate)) != null) {
                HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
                for (ICitizenData workerEntity : this.building.getAssignedCitizen()) {
                    handlers.add(workerEntity.getInventory());
                }
                if (!storage.canFullFillRecipe(count, Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) {
                    return null;
                }
            }
            return storage;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            ICitizenData assistant;
            if (this.building != null && (assistant = ((BuildingCook)this.building).getAssistant()) != null) {
                return assistant.getJob();
            }
            return new JobCookAssistant(null);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingCook.COOK_DESC);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            ItemStack output = recipe.getPrimaryOutput();
            return ItemStackUtils.CAN_EAT.test(output) || ItemStackUtils.CAN_EAT.test(FurnaceRecipes.getInstance().getSmeltingResult(output));
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            if (this.building == null) {
                return true;
            }
            return this.building.getBuildingLevel() >= 3;
        }

        @Override
        public boolean isVisible() {
            return this.building.getBuildingLevel() >= 3;
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            if (this.building.getBuildingLevel() < 3) {
                return false;
            }
            return super.canRecipeBeAdded(token);
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingCook.COOK_DESC);
        }
    }
}

